#pragma once

#include "counter.h"
#include "service.h"

#include <util/datetime/base.h>
#include <util/generic/vector.h>
#include <util/system/rwlock.h>

namespace NMonitor {

class TBasicPage : public TCounterSource {
public:
     TBasicPage();
    ~TBasicPage();

    void AddToHttpService(THttpService& service);

    void Print(IOutputStream& out) const;
    void Print(const TStringBuf& path, IOutputStream& out) const;
    void PrintJson(IOutputStream& out) const;

private:
    TNamedCounterTables FetchTables() const;

    bool CheckTableName(const TVector<TStringBuf>& selectors, const TCounterTableName& tableName) const;

private:
    class TNamedTableJsonWriter;

    const TInstant Started_;
    mutable TAtomic TableCountHint_;
};

} // namespace NMonitor
