#pragma once

#include <util/generic/ptr.h>
#include <util/stream/output.h>

#include <functional>

namespace NMonitor {

using THttpPage = std::function<void (const TStringBuf& subPath, IOutputStream& out)>;

class THttpService : TNonCopyable {
public:
    THttpService();
    ~THttpService();

    void AddPage(const TString& pathStart, const TString& descr, THttpPage cb);

    void Start(int port);
    void Stop();
private:
    class TImpl;
    THolder<TImpl> Impl_;
};

} // namespace NMonitor
