#include "tools.h"

#include <util/generic/algorithm.h>
#include <util/string/cast.h>

namespace NMonitor {

THistogramCounter::THistogramCounter(const std::initializer_list<int>& l, const TString& infBucketName, TCounterFlags flags)
    : Scale_(l)
    , InfBucketName_(infBucketName)
{
    if (!InfBucketName_.empty()) {
        Scale_.push_back(Scale_.back());
    }
    Counters_.resize(Scale_.size(), TCounter(0, flags));
}

void THistogramCounter::Update(int value, int delta) {
    auto it = LowerBound(Scale_.begin(), Scale_.end(), value);
    if (it != Scale_.end()) {
        auto pos = std::distance(Scale_.begin(), it);
        Counters_[pos] += delta;
    } else {
        // Складываем в последнюю корзину все значения,
        // выходящие за пределы заданного диапазона.
        Counters_.back() += delta;
    }
}

void THistogramCounter::QueryCounters(const TString& pfx, const TString& sfx, NMonitor::TCounterTable* ct) const {
    for (size_t i = 0; i < Scale_.size(); ++i) {
        auto name = (!InfBucketName_.empty() && i + 1 == Scale_.size()) ? InfBucketName_ : ToString(Scale_[i]);
        ct->insert(
            MAKE_NAMED_COUNTER_PAIR(pfx + name + sfx, Counters_[i])
        );
    }
}

TCountersList::TCountersList(size_t countersCount, TCounterFlags flags) {
    Counters_.resize(countersCount, TCounter(0, flags));
};

TCounter::TRawValue TCountersList::Val(size_t index) const {
    return Counters_[index].Val();
}

void TCountersList::Inc(size_t index) {
    Counters_[index].Inc();
};

void TCountersList::Dec(size_t index) {
    Counters_[index].Dec();
};

void TCountersList::Reset() {
    for (auto& counter: Counters_) {
        counter = 0;
    }
};

void TCountersList::QueryCounters(const TString& pfx, const TString& sfx, NMonitor::TCounterTable* ct) const {
    for (size_t i = 0; i < Counters_.size(); ++i) {
        ct->insert(
            MAKE_NAMED_COUNTER_PAIR(pfx + ToString(i) + sfx, Counters_[i])
        );
    }
};

} // NMonitor
