#pragma once

#include "counter.h"

#include <util/generic/string.h>
#include <util/generic/vector.h>

#include <initializer_list>
#include <stddef.h>

namespace NMonitor {

class THistogramCounter {
public:
    THistogramCounter(const std::initializer_list<int>& l, const TString& infBucketName = {}, TCounterFlags flags = 0);
    void Update(int value, int delta = 1);
    void QueryCounters(const TString& pfx, const TString& sfx, NMonitor::TCounterTable* ct) const;
private:
    TVector<int> Scale_;
    const TString InfBucketName_;
    TVector<TCounter> Counters_;
};

class TDerivHistogramCounter : public THistogramCounter {
public:
    TDerivHistogramCounter(const std::initializer_list<int>& l, const TString& infBucketName = {})
        : THistogramCounter(l, infBucketName, TCounterFlag::Deriv)
    {
    }
};

class TCountersList {
public:
    TCountersList(size_t countersCount, TCounterFlags flags = 0);
    TCounter::TRawValue Val(size_t index) const;
    void Inc(size_t index);
    void Dec(size_t index);
    void Reset();
    void QueryCounters(const TString& pfx, const TString& sfx, NMonitor::TCounterTable* ct) const;
private:
    TVector<TCounter> Counters_;
};

class TDerivCountersList : public TCountersList {
public:
    TDerivCountersList(size_t countersCount)
        : TCountersList(countersCount, TCounterFlag::Deriv)
    {
    }
};

template<class TCounterClass>
class TScopedCounterSetter {
public:
    TScopedCounterSetter(TCounterClass& counter, TCounter::TValue valueOnEnter, TCounter::TValue valueOnExit)
        : Counter(counter)
        , ValueOnExit(valueOnExit)
    {
        Counter = valueOnEnter;
    }

    ~TScopedCounterSetter() {
        Counter = ValueOnExit;
    }
private:
    TCounterClass& Counter;
    const TCounter::TValue ValueOnExit;
};

} // NMonitor
