#include "invalidation_rules.h"

namespace NTravel {
    TCacheInvalidationRuleBase::TCacheInvalidationRuleBase(TInstant timestamp)
        : Timestamp(timestamp)
    {
    }

    TCacheInvalidationRuleByCheckInOut::TCacheInvalidationRuleByCheckInOut() : TCacheInvalidationRuleBase(TInstant::Zero()) {}

    TCacheInvalidationRuleByCheckInOut::TCacheInvalidationRuleByCheckInOut(TMaybe<NOrdinalDate::TOrdinalDate> checkInDate, TMaybe<NOrdinalDate::TOrdinalDate> checkOutDate, TInstant timestamp)
        : TCacheInvalidationRuleBase(timestamp)
        , CheckInDate(checkInDate)
        , CheckOutDate(checkOutDate)
    {
    }

    TInstant TCacheInvalidationRuleByCheckInOut::GetInvalidationTimestamp(NOrdinalDate::TOrdinalDate checkIn, NOrdinalDate::TOrdinalDate checkOut) const {
        if ((CheckInDate.Empty() || CheckInDate == checkIn) && (CheckOutDate.Empty() || CheckOutDate == checkOut)) {
            return Timestamp;
        }
        return TInstant::Zero();
    }

    std::pair<TMaybe<NOrdinalDate::TOrdinalDate>, TMaybe<NOrdinalDate::TOrdinalDate>> TCacheInvalidationRuleByCheckInOut::GetKey() const {
        return std::make_pair(CheckInDate, CheckOutDate);
    }

    TCacheInvalidationRuleByTargetDates::TCacheInvalidationRuleByTargetDates() : TCacheInvalidationRuleBase(TInstant::Zero()) {}

    TCacheInvalidationRuleByTargetDates::TCacheInvalidationRuleByTargetDates(TMaybe<NOrdinalDate::TOrdinalDate> dateFrom, TMaybe<NOrdinalDate::TOrdinalDate> dateTo, TInstant timestamp)
        : TCacheInvalidationRuleBase(timestamp)
        , DateFrom(dateFrom.GetOrElse(std::numeric_limits<NOrdinalDate::TOrdinalDate>::min()))
        , DateTo(dateTo.GetOrElse(std::numeric_limits<NOrdinalDate::TOrdinalDate>::max()))
    {
    }

    TInstant TCacheInvalidationRuleByTargetDates::GetInvalidationTimestamp(NOrdinalDate::TOrdinalDate checkIn, NOrdinalDate::TOrdinalDate checkOut) const {
        if ((Max(DateFrom, checkIn) <= Min(DateTo, checkOut - 1))) {
            return Timestamp;
        }
        return TInstant::Zero();
    }

    std::pair<NOrdinalDate::TOrdinalDate, NOrdinalDate::TOrdinalDate> TCacheInvalidationRuleByTargetDates::GetKey() const {
        return std::make_pair(DateFrom, DateTo);
    }
}
