#pragma once

#include <travel/hotels/lib/cpp/ordinal_date/ordinal_date.h>

#include <travel/hotels/proto/offerbus_messages/bus_messages.pb.h>

#include <util/generic/maybe.h>

namespace NTravel {
    class TCacheInvalidationRuleBase {
    public:
        TInstant Timestamp;

        explicit TCacheInvalidationRuleBase(TInstant timestamp);
        virtual TInstant GetInvalidationTimestamp(NOrdinalDate::TOrdinalDate checkIn, NOrdinalDate::TOrdinalDate checkOut) const = 0;
        virtual ~TCacheInvalidationRuleBase() = default;
    };

    class TCacheInvalidationRuleByCheckInOut: public TCacheInvalidationRuleBase {
    public:
        TCacheInvalidationRuleByCheckInOut();
        TCacheInvalidationRuleByCheckInOut(TMaybe<NOrdinalDate::TOrdinalDate> checkInDate, TMaybe<NOrdinalDate::TOrdinalDate> checkOutDate, TInstant timestamp);
        TInstant GetInvalidationTimestamp(NOrdinalDate::TOrdinalDate checkIn, NOrdinalDate::TOrdinalDate checkOut) const override;
        std::pair<TMaybe<NOrdinalDate::TOrdinalDate>, TMaybe<NOrdinalDate::TOrdinalDate>> GetKey() const;

    private:
        TMaybe<NOrdinalDate::TOrdinalDate> CheckInDate;
        TMaybe<NOrdinalDate::TOrdinalDate> CheckOutDate;
    };

    class TCacheInvalidationRuleByTargetDates: public TCacheInvalidationRuleBase {
    public:
        TCacheInvalidationRuleByTargetDates();
        TCacheInvalidationRuleByTargetDates(TMaybe<NOrdinalDate::TOrdinalDate> dateFrom, TMaybe<NOrdinalDate::TOrdinalDate> dateTo, TInstant timestamp);
        TInstant GetInvalidationTimestamp(NOrdinalDate::TOrdinalDate checkIn, NOrdinalDate::TOrdinalDate checkOut) const override;
        std::pair<NOrdinalDate::TOrdinalDate, NOrdinalDate::TOrdinalDate> GetKey() const;

    private:
        NOrdinalDate::TOrdinalDate DateFrom;
        NOrdinalDate::TOrdinalDate DateTo;
    };
}
