#pragma once

#include <util/generic/string.h>
#include <util/datetime/base.h>

/* Библиотека для превращения строковой даты вида "2018-02-08" в число - количество дней с 1970-01-01.
 * Пример: "2017-08-10" == 17388
 */

namespace NTravel {

namespace NOrdinalDate {

using TOrdinalDate = int;

constexpr TOrdinalDate g_DateZero = 0;


class TInvalidDateException : public yexception {
};


TOrdinalDate FromString(const TString& date);
TString ToString(TOrdinalDate date);

TString PlusDays(const TString& date, int diff);

TOrdinalDate FromInstant(const TInstant& t);// По UTC
TInstant ToInstant(TOrdinalDate date); // 00:00 по UTC

void ToParts(TOrdinalDate date, int& year, int& month, int& day);
TOrdinalDate FromParts(int year, int month, int day);

int GetWeekDay(TOrdinalDate date); // По UTC, 0(Воскресенье) - 6(Суббота)

} // NOrdinalDate

} // NTravel
