#include <travel/hotels/lib/cpp/ordinal_date/ordinal_date.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NTravel;

Y_UNIT_TEST_SUITE(TestOrdinalDate) {
    Y_UNIT_TEST(CheckOrdinality) {
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::ToString(17388 + 1), "2017-08-11");
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::ToString(17388 + 31), "2017-09-10");
    }

    Y_UNIT_TEST(CheckFromString) {
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::FromString("2017-08-10"), 17388);
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::FromString("20170810"), 17388);
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::FromString("1970-01-02"), 1);
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::FromString("1970-01-03"), 2);
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::FromString("19700103"), 2);
    }
    Y_UNIT_TEST(CheckFromStringFail) {
        UNIT_ASSERT_EXCEPTION(NOrdinalDate::FromString("2017-08a-10"), NOrdinalDate::TInvalidDateException);
        UNIT_ASSERT_EXCEPTION(NOrdinalDate::FromString("1970-01-01"), NOrdinalDate::TInvalidDateException);
        UNIT_ASSERT_EXCEPTION(NOrdinalDate::FromString("123"), NOrdinalDate::TInvalidDateException);
    }
    Y_UNIT_TEST(CheckToString) {
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::ToString(17388), "2017-08-10");
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::ToString(17389), "2017-08-11");
    }
    Y_UNIT_TEST(CheckPlusDays) {
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::PlusDays("2019-01-31", 1), "2019-02-01");
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::PlusDays("2019-01-31", -10), "2019-01-21");
    }

    Y_UNIT_TEST(CheckFromInstant) {
        // Also Check that Instant is taken as UTC
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::FromInstant(TInstant::MicroSeconds(1525132799999999)), NOrdinalDate::FromString("2018-04-30"));
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::FromInstant(TInstant::MicroSeconds(1525132800000000)), NOrdinalDate::FromString("2018-05-01"));
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::FromInstant(TInstant::MicroSeconds(1525219199999999)), NOrdinalDate::FromString("2018-05-01"));
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::FromInstant(TInstant::MicroSeconds(1525219200000000)), NOrdinalDate::FromString("2018-05-02"));
    }
    Y_UNIT_TEST(CheckToInstant) {
        // Also Check that Instant is taken as UTC
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::ToInstant(NOrdinalDate::FromString("2018-05-01")), TInstant::MicroSeconds(1525132800000000));
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::ToInstant(NOrdinalDate::FromString("2018-05-02")), TInstant::MicroSeconds(1525219200000000));
    }

    Y_UNIT_TEST(CheckFromParts) {
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::FromParts(2018, 5, 1), NOrdinalDate::FromString("2018-05-01"));
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::FromParts(2018, 5, 2), NOrdinalDate::FromString("2018-05-02"));
    }
    Y_UNIT_TEST(CheckToParts) {
        int y, m, d;
        NOrdinalDate::ToParts(NOrdinalDate::FromString("2018-05-01"), y, m, d);
        UNIT_ASSERT_VALUES_EQUAL(y, 2018);
        UNIT_ASSERT_VALUES_EQUAL(m, 5);
        UNIT_ASSERT_VALUES_EQUAL(d, 1);
        NOrdinalDate::ToParts(NOrdinalDate::FromString("2017-12-31"), y, m, d);
        UNIT_ASSERT_VALUES_EQUAL(y, 2017);
        UNIT_ASSERT_VALUES_EQUAL(m, 12);
        UNIT_ASSERT_VALUES_EQUAL(d, 31);
    }

    Y_UNIT_TEST(CheckGetWeekDay) {
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::GetWeekDay(NOrdinalDate::FromString("2018-04-28")), 6);
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::GetWeekDay(NOrdinalDate::FromString("2018-05-01")), 2);
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::GetWeekDay(NOrdinalDate::FromString("2018-05-02")), 3);
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::GetWeekDay(NOrdinalDate::FromString("2018-05-05")), 6);
        UNIT_ASSERT_VALUES_EQUAL(NOrdinalDate::GetWeekDay(NOrdinalDate::FromString("2018-05-06")), 0);
    }

};
