#pragma once

#include <util/generic/string.h>
#include <util/generic/yexception.h>

/* Библиотека для конвертации путешественных возрастов в виде "1,2,8,88" в 28-битное число.
 * ages: строка возрастов, разделенных запятыми. Должны быть упорядочены по возрастанию.
 *    Каждый возраст - это число в диапазоне 1-15 (ребенок) или 88 (взрослый).
 *     Взрослых - от 1 до 15 (4 бита)
 *     Детей - от 0 до 4 (4 по 4 бита = 16 бит)
 *     Костыль для серпа:
 *     СпецДетей-2 года:  от 0 до 15 (4 бита)
 *     СпецДетей-15 лет:  от 0 до 15 (4 бита)
 *
 * packedAges: число ui32 с 28 значащими битами
 */

namespace NTravel {

namespace NPackedAges {

using TPackedAges = ui32;

constexpr TPackedAges g_AgesZero = 0;

class TInvalidAgesException : public yexception {
};

TPackedAges FromString(const TString& ages);
TString ToString(TPackedAges packedAges);

} // NPackedAges

} // NTravel
