#include <travel/hotels/lib/cpp/packed_ages/packed_ages.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NTravel;

Y_UNIT_TEST_SUITE(TestPackedAges) {
    TString Transform(const TString& ages) {
        return NPackedAges::ToString(NPackedAges::FromString(ages));
    }
    Y_UNIT_TEST(CheckSimple) {
        UNIT_ASSERT_VALUES_EQUAL(Transform("88"), "88");
        UNIT_ASSERT_VALUES_EQUAL(Transform("1,88"), "1,88");
        UNIT_ASSERT_VALUES_EQUAL(Transform("1,2,88"), "1,2,88");
        UNIT_ASSERT_VALUES_EQUAL(Transform("1,2,3,88,88"), "1,2,3,88,88");
        UNIT_ASSERT_VALUES_EQUAL(Transform("88,88,88,88,88"), "88,88,88,88,88");
        UNIT_ASSERT_VALUES_EQUAL(Transform("1,2,3,4"), "1,2,3,4");
    }
    Y_UNIT_TEST(CheckHackForSerp) {
        UNIT_ASSERT_VALUES_EQUAL(Transform("2,2,2,2,2,2,2,2,2,2,88"), "2,2,2,2,2,2,2,2,2,2,88");
        UNIT_ASSERT_VALUES_EQUAL(Transform("15,15,15,15,15,15,15,15,15,15,88"), "15,15,15,15,15,15,15,15,15,15,88");
    }
    Y_UNIT_TEST(CheckSorting) {
        UNIT_ASSERT_VALUES_EQUAL(Transform("88,1"), "1,88");
        UNIT_ASSERT_VALUES_EQUAL(Transform("2,1,88"), "1,2,88");
        UNIT_ASSERT_VALUES_EQUAL(Transform("2,88,1"), "1,2,88");
        UNIT_ASSERT_VALUES_EQUAL(Transform("88,2,3,1,88"), "1,2,3,88,88");
        UNIT_ASSERT_VALUES_EQUAL(Transform("4,2,1,3"), "1,2,3,4");
    }
    Y_UNIT_TEST(CheckWrong) {
        UNIT_ASSERT_EXCEPTION(NPackedAges::FromString(""), NPackedAges::TInvalidAgesException);
        UNIT_ASSERT_EXCEPTION(NPackedAges::FromString("ab"), NPackedAges::TInvalidAgesException);
        UNIT_ASSERT_EXCEPTION(NPackedAges::FromString("ab13"), NPackedAges::TInvalidAgesException);
        UNIT_ASSERT_EXCEPTION(NPackedAges::FromString("13a,4"), NPackedAges::TInvalidAgesException);
        UNIT_ASSERT_EXCEPTION(NPackedAges::FromString("99"), NPackedAges::TInvalidAgesException);
        UNIT_ASSERT_EXCEPTION(NPackedAges::FromString("88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88"), NPackedAges::TInvalidAgesException);
        UNIT_ASSERT_EXCEPTION(NPackedAges::FromString("1,1,1,1,1,1,1,1,1,1,1,1"), NPackedAges::TInvalidAgesException);
        UNIT_ASSERT_EXCEPTION(NPackedAges::FromString(",1"), NPackedAges::TInvalidAgesException);
        UNIT_ASSERT_EXCEPTION(NPackedAges::FromString("1,,1"), NPackedAges::TInvalidAgesException);
    }
};
