#include "original_id_to_permalink_mapper.h"

#include <util/generic/ptr.h>
#include <util/system/rwlock.h>
#include <util/generic/algorithm.h>

#include <type_traits>

namespace NTravel::NPermalinkMappers {

size_t TOriginalIdToPermalinkMapper::GetAllocSize(const TMappingElement& element) const {
    return element.first.GetAllocSize();
}

void TOriginalIdToPermalinkMapper::OnConvert(const NYT::TNode& row, NTravelProto::NPermalinkMappers::TOriginalIdToPermalinkMapperRec* proto) const {
    TPermalink permalink = ExtractPermalinkFromYtRow(row);
    EPartnerId partnerId = ExtractPartnerIdFromYtRow(row);
    TString originalId = ExtractOriginalIdFromYtRow(row);

    if ((partnerId != NTravelProto::PI_UNUSED) && originalId) {
        proto->MutableHotelId()->SetPartnerId(partnerId);
        proto->MutableHotelId()->SetOriginalId(originalId);
        proto->SetPermalink(permalink);
    }
}

void TOriginalIdToPermalinkMapper::OnData(const NTravelProto::NPermalinkMappers::TOriginalIdToPermalinkMapperRec& proto) {
    NewMapping_->push_back({THotelId::FromProto(proto.GetHotelId()), TPermalink(proto.GetPermalink())});
}

}// namespace NTravel::NPermalinkMappers
