#include "permalink_to_cluster_mapper.h"

namespace NTravel::NPermalinkMappers {

void TPermalinkToClusterMapper::OnConvert(const NYT::TNode& row, TProtoRecord* proto) const {
    proto->SetPermalink(row["permalink"].IntCast<i64>());
    proto->SetClusterPermalink(row["cluster_permalink"].IntCast<i64>());
}

void TPermalinkToClusterMapper::OnData(const TProtoRecord& proto) {
    auto clusterPermalink = TPermalink(proto.GetClusterPermalink());
    auto permalink = TPermalink(proto.GetPermalink());
    if (permalink != clusterPermalink) {
        NewMapping_->push_back({permalink, clusterPermalink});
    }
}

auto TPermalinkToClusterMapper::GetClusterPermalink(const TKey& permalink) const -> TValue {
    if (auto value = GetMapping(permalink)) {
        return *value;
    }
    return permalink;
}

auto TPermalinkToClusterMapper::GetCluster(const TKey& clusterPermalink) const -> TVector<TValue> {
    TVector<TValue> cluster;
    for (const auto& p: *GetMapping()) {
        if (p.second == clusterPermalink) {
            cluster.push_back(p.first);
        }
    }
    return cluster;
}

}// namespace NTravel::NPermalinkMappers
