#pragma once

#include <travel/hotels/lib/cpp/data/data.h>
#include <travel/hotels/lib/cpp/yt/persistent_mapper.h>
#include <travel/hotels/lib/cpp/permalink_mappers/proto/permalink_to_cluster_mapper_rec.pb.h>

#include <util/generic/vector.h>

namespace NTravel::NPermalinkMappers {

class TPermalinkToClusterMapper: public TYtPersistentMapper<TPermalink, TPermalink, NTravelProto::NPermalinkMappers::TPermalinkToClusterMapperRec> {
    using TBase = TYtPersistentMapper<TKey, TValue, TProtoRecord>;
public:
    using TBase::TBase;

    TValue GetClusterPermalink(const TKey& permalink) const;
    TVector<TValue> GetCluster(const TKey& clusterPermalink) const;
private:
    void OnConvert(const NYT::TNode& row, TProtoRecord* proto) const override;
    void OnData(const TProtoRecord& proto) override;
};

}// namespace NTravel::NPermalinkMappers
