#pragma once

#include <travel/hotels/lib/cpp/data/data.h>
#include <travel/hotels/lib/cpp/permalink_mappers/proto/permalink_to_original_ids_mapper_rec.pb.h>
#include <travel/hotels/lib/cpp/yt/persistent_mapper.h>

#include <util/generic/vector.h>

#include <utility>

namespace NTravel::NPermalinkMappers {

struct TPermalinkToOriginalIdsMappingRec {
    TVector<THotelId> PartnerIds;
    bool Contains(const THotelId& hId) const;
    size_t GetAllocSize() const;
};

class TPermalinkToOriginalIdsMapper: public TYtPersistentMapper<TPermalink, TPermalinkToOriginalIdsMappingRec, NTravelProto::NPermalinkMappers::TPermalinkToOriginalIdsMapperRec> {
    using TBase = TYtPersistentMapper<TPermalink, TPermalinkToOriginalIdsMappingRec, NTravelProto::NPermalinkMappers::TPermalinkToOriginalIdsMapperRec>;
public:
    using TBase::TBase;

    void SetPartnerIdByCode(const THashMap<TString, EPartnerId>& partnerIdByCode);
protected:
    TRWMutex PartnerIdByCodeLock_;
    THashMap<TString, EPartnerId> PartnerIdByCode_;

    size_t GetAllocSize(const TMappingElement& element) const override;
    void OnConvert(const NYT::TNode& row, NTravelProto::NPermalinkMappers::TPermalinkToOriginalIdsMapperRec* proto) const override;
    void OnData(const NTravelProto::NPermalinkMappers::TPermalinkToOriginalIdsMapperRec& proto) override;
};

struct TPermalinkToOriginalIdsMappingRecJoiner {
    static void Join(TPermalinkToOriginalIdsMapper::TValue* to, TPermalinkToOriginalIdsMapper::TValue* from);
};

}// namespace NTravel::NPermalinkMappers
