#pragma once

#include <travel/hotels/lib/cpp/mon/counter.h>
#include <travel/hotels/lib/cpp/util/flag.h>

#include <util/datetime/base.h>
#include <util/generic/queue.h>
#include <util/thread/factory.h>
#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/system/event.h>
#include <util/system/mutex.h>

namespace NTravel {

using TSchedulerCallback = std::function<void()>;


class TScheduler : public IThreadFactory::IThreadAble {
public:
    TScheduler() = default;
    ~TScheduler() override;

    void Start();
    void Stop();

    void RegisterCounters(NMonitor::TCounterSource& source);

    void Enqueue(TInstant at, TSchedulerCallback callback);
    void Enqueue(TDuration after, TSchedulerCallback callback);
    void EnqueuePeriodical(TDuration period, TSchedulerCallback callback);

    static TScheduler& Instance();
private:
    struct TCounters : public NMonitor::TCounterSource {
        NMonitor::TDerivCounter DutyNs;// Сколько наносекунд шедулер занят работой
        NMonitor::TDerivCounter LatenessNs; // на сколько задачи запаздывают
        NMonitor::TCounter      NTasksInQueue; // Сколько задач в очереди

        void QueryCounters(NMonitor::TCounterTable* ct) const override;
    };

    struct TTask {
        bool operator < (const TTask& r) const;
        TInstant NextTime;
        TSchedulerCallback Callback;
        bool IsPeriodical;
        TDuration Period;
    };

    TCounters Counters_;
    TAtomicFlag StopFlag_;
    TAtomicFlag IsStarted_;
    TAutoEvent WakeUp_;
    TMutex Lock_;
    TAutoPtr<IThreadFactory::IThread> Thread_;
    TPriorityQueue<TTask> Queue_;

    void DoExecute() override;

    void EnqueueTask(const TTask& task);
    TInstant GetNextTaskTime() const;
    TTask PopNextTask();
};

} // namespace NTravel
