#pragma once

#include <library/cpp/http/simple/http_client.h>
#include <library/cpp/json/writer/json.h>

#include <util/generic/string.h>

namespace NTravel {

class TSlackForwarderNotificator {
public:
    TSlackForwarderNotificator(const TString& url, const TString& componentName, ui64 taskId, ui64 revision);
    ~TSlackForwarderNotificator();

    void RegisterBuild(const TString& commitMessage, const TString& commiter);
    void RegisterBuildNoThrow(const TString& commitMessage, const TString& commiter);

    void ReportStatus(const TString& status);
    void ReportStatusNoThrow(const TString& status);
private:
    const TString ComponentName_;
    const ui64 TaskId_;
    const ui64 Revision_;

    TKeepAliveHttpClient HttpClient_;

    void SendNotification(const TString& type, const NJsonWriter::TBuf& data);
};

}//namespace NTravel
