#include "data.h"

#include <util/generic/string.h>
#include <util/generic/variant.h>
#include <util/generic/yexception.h>

namespace NTravel {
namespace NSQLite {

namespace NDetail {

struct StringVisitor {
    TString operator()(const TNone&) const {
        return {};
    }

    TString operator()(i64 from) const {
        return ToString(from);
    }

    TString operator()(double from) const {
        return ToString(from);
    }

    TString operator()(const TString& from) const {
        return from;
    }

    TString operator()(const TBlob& from) const {
        return from;
    }
};

} // NDetail

TString ToString(const TQueryParams& from) {
    return std::visit(NDetail::StringVisitor{}, from);
}

} // NSQLite
} // NTravel
