#pragma once

#include <travel/hotels/lib/cpp/mon/counter.h>

#include <travel/hotels/proto/app_config/tvm_service.pb.h>

#include <library/cpp/tvmauth/client/facade.h>

#include <util/generic/set.h>

namespace NTravel::NTvm {
    class TTvmService {
    public:
        explicit TTvmService(const NTravelProto::NAppConfig::TTvmServiceConfig& config);

        void RegisterCounters(NMonitor::TCounterSource& counters) const;

        bool IsAllowedServiceTicket(const TStringBuf& ticket) const;

        TString GetServiceTicketFor(const TStringBuf& dstAlias) const;

        bool IsEnabled() const;

    private:
        struct TCounters: public NMonitor::TCounterSource {
            explicit TCounters(const std::unique_ptr<NTvmAuth::TTvmClient>& tvmClient);

            mutable NMonitor::TCounter StatusOk;
            mutable NMonitor::TCounter StatusWarning;
            mutable NMonitor::TCounter StatusError;
            mutable NMonitor::TCounter StatusUnknown;

            mutable NMonitor::TCounter PublicKeysAgeSec;
            mutable NMonitor::TCounter PublicKeysTimeToInvalidationSec;

            mutable NMonitor::TDerivCounter NRequests;
            mutable NMonitor::TDerivCounter NAllowedTickets;
            mutable NMonitor::TDerivCounter NRefusedTickets;

            mutable NMonitor::TDerivCounter NFetchedServiceTicket;
            mutable NMonitor::TDerivCounter NFailedToFetchServiceTicket;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;

            const std::unique_ptr<NTvmAuth::TTvmClient>& TvmClient;
        };

        bool Enabled;
        std::unique_ptr<NTvmAuth::TTvmClient> TvmClient;
        TSet<ui32> AllowedSources;
        TCounters Counters;

        bool IsAllowedServiceTicketImpl(const TStringBuf& ticket) const;
    };

}
