#include "arcadia.h"

#include <util/system/env.h>
#include <util/folder/path.h>
#include <util/system/fs.h>

#include <library/cpp/logger/global/global.h>

namespace NTravel {

TString FindArcadiaRoot() {
    if (TString path = GetEnv("ARCADIA_ROOT")) {
        if (TFsPath(path).Exists()) {
            DEBUG_LOG << "Arcadia root detected by $ARCADIA_ROOT: " << path << Endl;
            return path;
        }
    }
    TFsPath path(NFs::CurrentWorkingDirectory());
    while (true) {
        if (path.Child(".arcadia.root").Exists()) {
            DEBUG_LOG << "Arcadia root detected by .arcadia.root: " << path << Endl;
            return path;
        }
        TFsPath parent = path.Parent();
        if (parent == path) {
            throw yexception() << "Failed to find Arcadia root";
        }
        path = parent;
    }
}

TString GetArcadiaPath(const TVector<TString>& parts) {
    TFsPath path(FindArcadiaRoot());
    for (const TString& part: parts) {
        path = path.Child(part);
    }
    return path;
}

} //namespace NTravel
