#include "arg_replacer.h"

#include <library/cpp/json/json_reader.h>

#include <util/generic/hash.h>
#include <util/string/subst.h>
#include <util/system/env.h>

namespace NTravel {

TArgReplacer::TArgReplacer(int argc, const char* argv[]) {
    TString replacesStr = GetEnv("ARG_REPLACES");
    THashMap<TString, TString> replaces;
    if (replacesStr) {
        NJson::TJsonValue json;
        NJson::ReadJsonTree(replacesStr, &json, true);
        for (const auto& [key, jsonValue]: json.GetMapSafe()) {
            replaces[key] = jsonValue.GetStringSafe();
        }
    }

    Args.reserve(argc);
    Argv = new const char*[argc];
    for (int i = 0; i < argc; ++i) {
        TString arg = argv[i];
        for (const auto& [key, value]: replaces) {
            SubstGlobal(arg, key, value);
        }
        Args.push_back(arg);
        Argv[i] = Args.back().c_str();
    }
}

TArgReplacer::~TArgReplacer() {
    delete[] Argv;
}

int TArgReplacer::GetArgC() const {
    return (int)Args.size();
}
const char** TArgReplacer::GetArgV() const {
    return Argv;
}


} //namespace NTravel
