#include "compress.h"

#include <library/cpp/string_utils/base64/base64.h>

namespace NTravel {

TString Base64EncodeUrlShort(const TString& data) {
    TString result = Base64EncodeUrl(data);
    // Аркадийный base64-url делает паддинг из запятых, а нам паддинг вообще ни к чему
    while (result.EndsWith(',')) {
        result.pop_back();
    }
    return result;
}

TString Base64DecodeAny(const TString& data) {
    if (data.length() % 4 == 0) {
        return Base64StrictDecode(data);
    }
    return Base64StrictDecode(TString(data) + TString(4 - (data.length() % 4), '='));
}

} // NTravel
