#include "exp.h"

#include <util/string/ascii.h>

namespace NTravel {

void TExp::Init(const ::google::protobuf::RepeatedField<::google::protobuf::int32>& exps,
     const ::google::protobuf::RepeatedPtrField<TProtoStringType>& strExps,
     const ::google::protobuf::RepeatedField<::google::protobuf::int32>& forceEnableExps,
     const ::google::protobuf::RepeatedField<::google::protobuf::int32>& forceDisableExps) {
    Exps = exps;
    StrExps = strExps;
    ForceEnableExps = forceEnableExps;
    ForceDisableExps = forceDisableExps;
    ExpCache.clear();
    StrExpCache.clear();
}


bool TExp::IsExp(int expId) const {
    auto it = ExpCache.find(expId);
    if (it != ExpCache.end()) {
        return it->second;
    }
    bool exp = IsExpNotCached(expId);
    ExpCache[expId] = exp;
    return exp;
}

bool TExp::IsExpNotCached(int expId) const {
    for (auto e: ForceDisableExps) {
        if (expId == e) {
            return false;
        }
    }
    for (auto e: ForceEnableExps) {
        if (expId == e) {
            return true;
        }
    }
    for (auto e: Exps) {
        if (e == expId) {
            return true;
        }
    }
    return false;
}


bool TExp::IsStrExp(const TString& expId) const {
    const TString& val = StrExpVal(expId, "0");
    return val != "0" && !AsciiEqualsIgnoreCase(val, TStringBuf("false"));
}

TString TExp::StrExpVal(const TString& key, const TString& def) const {
    auto it = StrExpCache.find(key);
    if (it != StrExpCache.end()) {
        return it->second.GetOrElse(def);
    }
    auto exp = StrExpValNotCached(key);
    StrExpCache[key] = exp;
    return exp.GetOrElse(def);
}

TMaybe<TString> TExp::StrExpValNotCached(const TString& key) const {
    for (const TString& k: StrExps) {
        if (k == key) {
            return TString();
        }
        if (k.StartsWith(key) && k.length() > key.length() && k[key.length()] == '=') {
            return k.substr(key.length() + 1);
        }
    }
    return Nothing();
}

} // namespace NTravel
