#pragma once

#include <google/protobuf/repeated_field.h>

#include <util/generic/string.h>
#include <util/generic/maybe.h>
#include <util/generic/hash.h>

namespace NTravel {

class TExp {
public:
    void Init(const ::google::protobuf::RepeatedField<::google::protobuf::int32>& exps,
         const ::google::protobuf::RepeatedPtrField<TProtoStringType>& strExps,
         const ::google::protobuf::RepeatedField<::google::protobuf::int32>& forceEnableExps = {},
         const ::google::protobuf::RepeatedField<::google::protobuf::int32>& forceDisableExps = {}
         );

    bool IsExp(int expId) const;

    // true, если есть ключ и значение не '0' и не 'false'. Даже если значение пустое
    bool IsStrExp(const TString& expId) const;

    // value по ключу, разделение по '='. Если '=' нет,то считаем, что значение - пустое
    TString StrExpVal(const TString& key, const TString& def = {}) const;
private:
    ::google::protobuf::RepeatedField<::google::protobuf::int32>  Exps;
    ::google::protobuf::RepeatedPtrField<TProtoStringType> StrExps;
    ::google::protobuf::RepeatedField<::google::protobuf::int32>  ForceEnableExps;
    ::google::protobuf::RepeatedField<::google::protobuf::int32>  ForceDisableExps;

    mutable THashMap<int, bool> ExpCache;
    mutable THashMap<TString, TMaybe<TString>> StrExpCache;

    bool IsExpNotCached(int expId) const;

    TMaybe<TString> StrExpValNotCached(const TString& key) const;
};

} // namespace NTravel
