#pragma once

#include <library/cpp/deprecated/atomic/atomic.h>

class TAtomicFlag {
public:
    inline TAtomicFlag()
        : Value_(0)
    { }

    inline explicit TAtomicFlag(const bool val)
        : Value_(val ? 1 : 0)
    { }

    inline operator bool() const {
        return AtomicGet(Value_) != 0;
    }

    inline void Clear() {
        AtomicSet(Value_, 0);
    }

    inline void Set() {
        AtomicSet(Value_, 1);
    }

    inline TAtomicFlag& operator = (bool value) {
        AtomicSet(Value_, value ? 1: 0);
        return *this;
    }

    inline bool TrySet() {
        return AtomicCas(&Value_, 1, 0);
    }

private:
    TAtomic Value_;
};
