#include "host_filter.h"

namespace NTravel {

bool IsHostAllowed(const TString& host, const ::google::protobuf::RepeatedPtrField<TProtoStringType>& allowedHosts) {
    if (!host) {
        return false;
    }
    for (const TString& allowedHost: allowedHosts) {
        if (allowedHost.StartsWith('.')) {
            if (host.EndsWith(allowedHost)) {
                return true;
            }
        } else {
            if (host == allowedHost) {
                return true;
            }
        }
    }
    return false;
}

TString GetAllowedHostOrDefault(const TString& host, const ::google::protobuf::RepeatedPtrField<TProtoStringType>& allowedHosts, const TString& defaultHost) {
    if (IsHostAllowed(host, allowedHosts)) {
        return host;
    }
    return defaultHost;
}

} // namespace NTravel
