#pragma once

#include <google/protobuf/repeated_field.h>

#include <util/generic/string.h>

namespace NTravel {

bool IsHostAllowed(const TString& host, const ::google::protobuf::RepeatedPtrField<TProtoStringType>& allowedHosts);

TString GetAllowedHostOrDefault(const TString& host, const ::google::protobuf::RepeatedPtrField<TProtoStringType>& allowedHosts, const TString& defaultHost);

} // namespace NTravel
