#include "object_deduplicator.h"

namespace NTravel {
    TObjectDeduplicator::TObjectDeduplicator(const TString& name)
        : Name_(name)
        , Counters_({"category"})
    {
    }

    void TObjectDeduplicator::RegisterCounters(NMonitor::TCounterSource& source) const {
        source.RegisterSource(&Counters_, Name_);
    }

    void TObjectDeduplicator::TStorageCounters::QueryCounters(NMonitor::TCounterTable* ct) const {
        ct->insert(MAKE_COUNTER_PAIR(NRecords));
        ct->insert(MAKE_COUNTER_PAIR(NBytes));
    }
}
