#pragma once

#include <util/datetime/base.h>
#include <util/system/hp_timer.h>

namespace NTravel {

class TProfileTimer {
public:
    static void Init() {
        volatile auto cps = NHPTimer::GetClockRate(); // 45 milliseconds to calibrate timer by clock
        Y_FAKE_READ(cps);
    }
    TDuration Get() const {
        return TDuration::MicroSeconds(Timer_.Passed() * 1E6);
    }
    TDuration Step() {
        return TDuration::MicroSeconds(Timer_.PassedReset() * 1E6);
    }
    void Reset() {
        Timer_.Reset();
    }
private:
    THPTimer Timer_;
};

} // NTravel
