#pragma once

#include <travel/hotels/lib/cpp/util/restart_detector.pb.h>
#include <travel/hotels/lib/cpp/mon/counter.h>

#include <util/generic/string.h>
#include <util/folder/path.h>

namespace NTravel {

class TRestartDetector : public NMonitor::TCounterSource {
public:
    TRestartDetector(const TString& stateFilePath);

    void ReportShutdown();

    void QueryCounters(NMonitor::TCounterTable* ct) const override;

    void RegisterCounters(NMonitor::TCounterSource& counters) const;

private:

    void LoadState();

    void SaveState() const;

    const TFsPath Path;

    mutable NMonitor::TCounter SuspiciousStartsCount;

    NTravelProto::TRestartDetectorState State_;

    TInstant StartTime_;
};

}// NTravel
