#include "secret_reader.h"

#include <util/system/env.h>
#include <util/stream/file.h>


namespace NTravel {

TString ReadSecret(const TString& path) {
    if (!path) {
        return "";
    }
    if (path.StartsWith("ENV.")) {
        return GetEnv(path.substr(4));
    } else {
        TString secret = TIFStream(path).ReadAll();
        while (!secret.empty() && isspace(secret.back())) {
            secret.pop_back();
        }
        return secret;
    }
}

} // namespace NTravel

