#pragma once

#include "travel/hotels/proto/app_config/string_deduplicator.pb.h"
#include <util/generic/hash_set.h>
#include <util/generic/string.h>
#include <util/system/rwlock.h>

struct TStringDeduplicator {
    TStringDeduplicator(const NTravelProto::NAppConfig::TConfigStringDeduplicator& cfg)
        : MaxSize_(cfg.GetMaxSize())
        , Enabled_(cfg.GetEnabled())
    {
        Strings_.reserve(MaxSize_);
    }

    TString Deduplicate(const TString& s) {
        if (!Enabled_) {
            return s;
        }
        {
            TReadGuard g(Lock_);
            auto it = Strings_.find(s);
            if (it != Strings_.end()) {
                return *it;
            }
        }
        TWriteGuard g(Lock_);
        if (Strings_.size() == MaxSize_) {
            Strings_.clear();
        }
        return *Strings_.insert(s).first;
    }
private:
    const size_t MaxSize_;
    const bool Enabled_;
    TRWMutex Lock_;
    THashSet<TString> Strings_;
};
