#include "url.h"


#include <library/cpp/cgiparam/cgiparam.h>

#include <util/generic/yexception.h>

namespace NTravel {

TUrl::TUrl() {
}

TUrl::TUrl(const TUrl& rhs)
: Uri(rhs.Uri)
{
}

TUrl::TUrl(const TString& url) {
    Parse(url);
}

void TUrl::Parse(const TString& url) {
    static const NUri::TParseFlags URL_PARSE_FLAGS =
          ( NUri::TFeature::FeaturesRecommended
          | NUri::TFeature::FeatureConvertHostIDN
          | NUri::TFeature::FeatureEncodeExtendedDelim
          | NUri::TFeature::FeatureEncodePercent
          ) & ~NUri::TFeature::FeatureHashBangToEscapedFragment;

    NUri::TState::EParsed state = Uri.Parse(url, URL_PARSE_FLAGS);
    if (state != NUri::TState::EParsed::ParsedOK) {
        throw yexception() << "Failed to parse url '" << url << "', state: " << state;
    }
}

TString TUrl::ToString() const {
    TString res;
    int flags = NUri::TField::FlagAllFields;
    TCgiParameters cgiParams(Uri.GetField(NUri::TField::FieldQuery));
    if (cgiParams.empty()) {
        flags = flags & (~NUri::TField::FlagQuery);
    }
    Uri.Print(res, flags);
    if (res.EndsWith("/")) {
        res.pop_back();
    }
    return res;
}

void TUrl::SetCgiParam(const TString& param, const TString& value) {
    TCgiParameters cgiParams(Uri.GetField(NUri::TField::FieldQuery));
    cgiParams.EraseAll(param);
    if (value) {
        cgiParams.InsertUnescaped(param, value);
    }
    TString params = cgiParams.Print();// Строка должна жить до вызова ~TUriUpdate
    {
        NUri::TUriUpdate upd(Uri);
        upd.Set(NUri::TField::FieldQuery, params);
    }
}

TString TUrl::GetHost() const {
    return TString(Uri.GetHost());
}

void TUrl::SetHost(const TString& hostNew) {
    NUri::TUriUpdate upd(Uri);
    upd.Set(NUri::TField::FieldHost, hostNew);
}

TString TUrl::GetPath() const {
    return TString(Uri.GetField(NUri::TField::FieldPath));
}

void TUrl::SetPath(const TString& path) {
    NUri::TUriUpdate upd(Uri);
    upd.Set(NUri::TField::FieldPath, path);
}

void TUrl::SetScheme(const NUri::TScheme::EKind scheme) {
    Uri.SetScheme(scheme);
}


}// NTravel
