#pragma once

#include <library/cpp/uri/uri.h>
#include <util/generic/string.h>

namespace NTravel {

class TUrl {
public:
    TUrl();
    TUrl(const TUrl& rhs);
    TUrl(const TString& url);

    void Parse(const TString& url);
    TString ToString() const;

    void SetCgiParam(const TString& param, const TString& value);

    TString GetHost() const;
    void SetHost(const TString& host);

    TString GetPath() const;
    void SetPath(const TString& path);

    void SetScheme(const NUri::TScheme::EKind scheme);
private:
    NUri::TUri Uri;
};


} // NTravel
