#pragma once

#define ZDICT_STATIC_LINKING_ONLY

#include <contrib/libs/zstd/include/zstd.h>

#include <library/cpp/threading/thread_local/thread_local.h>

#include <util/generic/buffer.h>
#include <util/generic/fwd.h>

namespace NTravel {
    class TZStdCompressor {
    public:
        explicit TZStdCompressor(int compressionLevel);
        void Compress(TStringBuf in, TBuffer& out) const;
        void Decompress(TStringBuf in, TBuffer& out) const;
        void Train(const TVector<TString>& strings);
        size_t GetDictSize() const;

    private:
        using TCDict = std::unique_ptr<ZSTD_CDict, size_t (*)(ZSTD_CDict*)>;
        using TDDict = std::unique_ptr<ZSTD_DDict, size_t (*)(ZSTD_DDict*)>;
        using TCCtx = std::unique_ptr<ZSTD_CCtx, size_t (*)(ZSTD_CCtx*)>;
        using TDCtx = std::unique_ptr<ZSTD_DCtx, size_t (*)(ZSTD_DCtx*)>;

        int CompressionLevel;
        NThreading::TThreadLocalValue<std::unique_ptr<TCCtx>> CompressionContext;
        NThreading::TThreadLocalValue<std::unique_ptr<TDCtx>> DecompressionContext;
        TCDict CompressionDict;
        TDDict DecompressionDict;
        TBuffer DictBuffer;
    };
}
