#pragma once

#include "yp_cached_resolver.h"

#include <travel/hotels/lib/cpp/util/flag.h>
#include <travel/hotels/proto/app_config/yp_auto_resolver.pb.h>

#include <util/system/event.h>
#include <util/system/mutex.h>
#include <util/thread/factory.h>

namespace NTravel {

TString ConvertToAddress(const TYpConnectionInfo& connectionInfo);

using TYpAutoResolverCallback = std::function<void(const TVector<TYpConnectionInfo>&)>;

class TYpAutoResolver : public IThreadFactory::IThreadAble {
public:
    TYpAutoResolver(const NTravelProto::NAppConfig::TConfigYpAutoResolver& config);
    ~TYpAutoResolver() override;

    void Start();
    void Stop();

    void SetCallback(const TYpAutoResolverCallback& callback);

    void ForceUpdate();
private:
    const TString EndpointSetId_;
    const TDuration CooldownDuration_;
    const NTravelProto::NAppConfig::TConfigYpAutoResolver::TFixedAddressList FixedAddresses_;

    TVector<THolder<TYpCachedResolver>> Resolvers_;

    TMutex Lock_;
    TYpAutoResolverCallback Callback_;

    TVector<TYpConnectionInfo> LastResponse_;

    TAutoPtr<IThreadFactory::IThread> Thread_;
    TAtomicFlag StopFlag_;
    TAutoEvent WakeUp_;

    void InformSubscriber(const TVector<TYpConnectionInfo>& endpoints) const;
    void DoExecute() override;
};

} // namespace NTravel
