#pragma once

#include <travel/hotels/lib/cpp/yp_auto_resolver/yp_connection_info.pb.h>

#include <infra/yp_service_discovery/resolver/resolver.h>

#include <util/folder/path.h>
#include <util/generic/maybe.h>

using NTravelProto::TYpConnectionInfo;

namespace NTravel {

class TYpCachedResolver {
public:
    TYpCachedResolver(const TString& address, const TString& cluster, const TString& endpointSetId, const TFsPath& cacheDirectory);

    TVector<TYpConnectionInfo> Resolve();
private:
    const TString Cluster_;
    const TString EndpointSetId_;
    const TFsPath CachePath_;
    NServiceDiscovery::TResolver Resolver_;
    TVector<TYpConnectionInfo> CachedEndpoints_;

    void SaveEndpointsToDisk(const TVector<TYpConnectionInfo>& endpoints) const;
    TVector<TYpConnectionInfo> LoadEndpointsFromDisk() const;

    static TVector<TYpConnectionInfo> ConvertEndpointsFromYpFormat(
        const TVector<NYP::NServiceDiscovery::NApi::TEndpoint>& endpoints);
};

} // namespace NTravel
