#pragma once

#include <travel/proto/commons.pb.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/system/types.h>

namespace NTravel {

struct TYtQueueMessageOrigin {
    TString ClusterName;
    int TabletIndex;
    i64 RowIndex;
    bool operator == (const TYtQueueMessageOrigin& rhs) const;
    size_t Hash() const;
};

struct TYtQueueMessagePacked {
    TInstant Timestamp;
    TInstant ExpireTimestamp;
    TString  MessageType;
    NTravelProto::EMessageCodec Codec;
    TString  BytesPacked;
    TString  MessageId;
    TYtQueueMessageOrigin Origin;
};

struct TYtQueueMessage {
    TInstant Timestamp;
    TInstant ExpireTimestamp;
    TString  MessageType;
    TString  Bytes;
    TString  MessageId;
    TYtQueueMessageOrigin Origin;
};

} // namespace NTravel

template <>
struct THash<NTravel::TYtQueueMessageOrigin> {
    inline size_t operator()(const NTravel::TYtQueueMessageOrigin& object) const {
        return object.Hash();
    }
};
