#include "deduplicaton_service.h"

namespace NTravel {

TDeduplicationService::TDeduplicationService(TDuration itemTtl, bool enableDeduplication)
    : SeenStrings_(itemTtl)
    , SeenUuids_(itemTtl)
    , EnableDeduplication_(enableDeduplication)
    , Counters_({"DeduplicationType"}) {}

bool TDeduplicationService::IsNewKey(const TString& key, TInstant timestamp) {
    if (!EnableDeduplication_) {
        return true;
    }
    TGUID uuid;
    if (GetUuid(key, uuid) || GetGuid(key, uuid)) {
        return !Contains(uuid, timestamp, "ByUuid", &SeenUuids_);
    }
    return !Contains(key, timestamp, "ByString", &SeenStrings_);
}

bool TDeduplicationService::CheckIfKeyNewAndRememberIt(const TString& key, TInstant timestamp) {
    if (!EnableDeduplication_) {
        return true;
    }
    TGUID uuid;
    if (GetUuid(key, uuid) || GetGuid(key, uuid)) {
        return InsertInto(uuid, timestamp, "ByUuid", &SeenUuids_);
    }
    return InsertInto(key, timestamp, "ByString", &SeenStrings_);
}

template<class TKey>
bool TDeduplicationService::Contains(const TKey& key, TInstant timestamp, const TString& name, THashSetWithTtl<TKey>* hashSet) {
    auto result = hashSet->Contains(key, timestamp);
    auto counters = Counters_.GetOrCreate({name});
    counters->DeduplicationTotalBytes = hashSet->GetCounters().DeduplicationTotalBytes.Val();
    counters->DeduplicationTotalElements = hashSet->GetCounters().DeduplicationTotalElements.Val();
    return result;
}

template<class TKey>
bool TDeduplicationService::InsertInto(const TKey& key, TInstant timestamp, const TString& name, THashSetWithTtl<TKey>* hashSet) {
    auto result = hashSet->Insert(key, timestamp);
    auto counters = Counters_.GetOrCreate({name});
    counters->DeduplicationTotalBytes = hashSet->GetCounters().DeduplicationTotalBytes.Val();
    counters->DeduplicationTotalElements = hashSet->GetCounters().DeduplicationTotalElements.Val();
    return result;
}

void TDeduplicationService::RegisterCounters(NMonitor::TCounterSource& source, const TString& name) const {
    source.RegisterSource(&Counters_, name);
}

} // namespace NTravel