#pragma once

#include <travel/hotels/lib/cpp/mon/counter.h>
#include <travel/hotels/lib/cpp/mon/counter_hypercube.h>
#include <travel/hotels/lib/cpp/util/hash_set_with_ttl.h>

#include <util/generic/string.h>
#include <util/generic/guid.h>
#include <util/datetime/base.h>

namespace NTravel {

class TDeduplicationService {
public:
    TDeduplicationService(TDuration itemTtl, bool enableDeduplication);
    bool IsNewKey(const TString& key, TInstant timestamp);
    bool CheckIfKeyNewAndRememberIt(const TString& key, TInstant timestamp);
    void RegisterCounters(NMonitor::TCounterSource& source, const TString& name) const;
private:
    THashSetWithTtl<TString> SeenStrings_;
    THashSetWithTtl<TGUID> SeenUuids_;
    bool EnableDeduplication_;

    template<class TKey>
    bool Contains(const TKey& key, TInstant timestamp, const TString& name, THashSetWithTtl<TKey>* hashSet);

    template<class TKey>
    bool InsertInto(const TKey& key, TInstant timestamp, const TString& name, THashSetWithTtl<TKey>* hashSet);

    NMonitor::TCounterHypercube<THashSetWithTtlCounters> Counters_;
};

} // namespace NTravel
