#pragma once

#include <travel/hotels/lib/cpp/util/flag.h>
#include <travel/hotels/proto/app_config/yt_lock.pb.h>

#include <mapreduce/yt/interface/client.h>

#include <util/system/event.h>

#include "functional"

namespace NTravel {

class TYtLock {
public:
    TYtLock(const NTravelProto::NAppConfig::TConfigYtLock& cfg);
    ~TYtLock();

    void SetStartHandler(std::function<void()> onStart);
    void SetStopHandler(std::function<void()> onStop);

    void Run();
    void Stop();
private:
    enum class ELockStatus {
        Failed,
        TimedOut,
        Acquired
    };

    const NTravelProto::NAppConfig::TConfigYtLock Config_;
    const bool IsFallbackHost_;

    TAtomicFlag              IsRunning_;
    TAutoEvent               WakeUp_;
    std::function<void()>    OnStart_;
    std::function<void()>    OnStop_;
    NYT::IClientPtr          YtClient_;

    void OnStart();
    void OnStop();

    ELockStatus TryAcquireLock(const std::function<void()>& beforeLock, const std::function<void()>& afterLock);
    void DoPeriodically(std::function<bool()> periodicFunc);
};

}  // namespace NTravel
