#pragma once

#include "data.h"

#include <travel/hotels/lib/cpp/yt/queue_reader.h>

#include <util/generic/set.h>
#include <util/generic/hash.h>

namespace NTravel {

class TYtQueueReaderWithConfirmation {
public:
    using TConfRecordHandler = TYtQueueReader::TRecordHandler;

    TYtQueueReaderWithConfirmation(const NTravelProto::NAppConfig::TConfigYtQueueReader& config, const TString& name, TDuration maxAge);

    void RegisterCounters(NMonitor::TCounterSource& source);
    void Start();
    void Stop();

    void Subscribe(const NProtoBuf::Message& message, const TConfRecordHandler& handler);
    template <class TOwner>
    void Subscribe(const NProtoBuf::Message& message, TOwner* owner, bool(TOwner::*membHandler)(const TYtQueueMessage& message))
    {
        Subscribe(message, [owner, membHandler](const TYtQueueMessage& message) {
            return (owner->*membHandler)(message);
        });
    }

    void MarkRecordAsCompleted(const TString& recordId);
private:
    struct TRowIndexWithStatus {
        i64 RowIndex;
        bool IsCompleted;

        TRowIndexWithStatus(i64 rowIndex, bool isCompleted);
        bool operator<(const TRowIndexWithStatus& rhs) const;
    };

    const TDuration MaxAge_;
    TYtQueueReader Reader_;

    TMutex Lock_;
    THashMap<TString/*RecordId*/, TVector<TYtQueueMessageOrigin>> InProgressRecordOriginsByRecordIdFirstGen_;
    THashMap<TString/*RecordId*/, TVector<TYtQueueMessageOrigin>> InProgressRecordOriginsByRecordIdSecondGen_;
    THashSet<TString/*RecordId*/> CompletedRecordsFirstGen_;
    THashSet<TString/*RecordId*/> CompletedRecordsSecondGen_;
    // These map keys TYtQueueMessageOrigin have RowIndex == 0
    THashMap<TYtQueueMessageOrigin, TSet<TRowIndexWithStatus>> ActiveRowIndicesByTabletOriginFirstGen_;
    THashMap<TYtQueueMessageOrigin, TSet<TRowIndexWithStatus>> ActiveRowIndicesByTabletOriginSecondGen_;

    void MarkRecordOriginAsCompletedUnlocked(const TYtQueueMessageOrigin& origin);
};

} // namespace NTravel
