#pragma once

#include "tools.h"
#include "data.h"

#include <travel/hotels/proto2/hotels.pb.h>
#include <travel/hotels/proto/app_config/yt_queue.pb.h>

#include <travel/hotels/lib/cpp/mon/tools.h>
#include <travel/hotels/lib/cpp/util/flag.h>
#include <travel/hotels/lib/cpp/util/profiletimer.h>

#include <util/generic/hash.h>
#include <util/generic/hash_set.h>
#include <util/generic/map.h>
#include <util/generic/vector.h>
#include <util/thread/factory.h>
#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/system/mutex.h>
#include <util/system/event.h>

namespace NTravel {

class TYtQueueWriter {
public:
    TYtQueueWriter(const NTravelProto::NAppConfig::TConfigYtQueueWriter& config, const TString& name);
    ~TYtQueueWriter();

    void RegisterCounters(NMonitor::TCounterSource& source);

    void Start();
    void Stop();

    void Write(const NProtoBuf::Message& proto, TDuration lifetime = TDuration());
    void Write(const NProtoBuf::Message& proto, TInstant timestamp, TString messageId, TDuration lifetime = TDuration());
    bool IsFlushed() const;
private:
    struct TCounters : public NMonitor::TCounterSource {
        NMonitor::TCounter      NAliveClusters;
        NMonitor::TDerivCounter NRecords;
        NMonitor::TDerivCounter NBytes;

        NMonitor::TDerivCounter NWriteError; // Единичные ошибки чтения

        void QueryCounters(NMonitor::TCounterTable* ct) const override;
    };

    const NTravelProto::NAppConfig::TConfigYtQueueWriter Config_;
    const TString Name_;

    NTravel::NYtRpc::TClientCreator ClientCreator_;

    mutable TCounters Counters_;

    TAtomicFlag StopFlag_;

    struct TCluster : public TThrRefBase {
        // TODO ping
        TString Name;
        TString PrintName;

        TAutoPtr<IThreadFactory::IThread> Thread;
        TAutoEvent WakeUp;

        NYT::NApi::IClientPtr YtClient;
        bool IsAlive = false;

        TMutex Lock;
        TVector<TVector<TYtQueueMessagePacked>> MessagePacks;
        size_t MessageCountToWrite = 0;
    };
    using TClusterRef = TIntrusivePtr<TCluster>;

    THashMap<TString, TClusterRef> Clusters_;

    void ThreadFunc(TClusterRef cluster);
    void WriteMessages(TClusterRef cluster, const TVector<TYtQueueMessagePacked>& messages);

    void EnsureAlive(TClusterRef cluster);
    void PingCluster(TClusterRef cluster);

    void ChangeClusterAlive(TClusterRef cluster, bool isAlive);

    static TString Compress(NTravelProto::EMessageCodec codec, size_t compressionLevel, const TString& bytes);
};

}// namespace NTravel
