#include "table_cache.h"

#include <util/generic/hash_set.h>

namespace NTravel {

namespace {
    TMutex g_Lock;
    THashSet<TString> g_YtTableCacheNames;
}

void InternalRegisterYtTableCache(const TString& name) {
    with_lock (g_Lock) {
        if (!g_YtTableCacheNames.insert(name).second) {
            throw yexception() << "TYtTableCache should have unique name, but " << name << " is duplicated";
        }
    }
}

}//namespace NTravel
