#include "tools.h"

#include "travel/hotels/lib/cpp/util/secret_reader.h"

#include <yt/yt/core/misc/shutdown.h>
#include <yt/yt/core/net/address.h>
#include <yt/yt/client/api/config.h>
#include <yt/yt/client/api/rpc_proxy/connection.h>
#include <yt/yt/client/api/rowset.h>
#include <yt/yt/client/api/transaction.h>
#include <yt/yt/client/api/rpc_proxy/config.h>
#include <yt/yt/client/api/rpc_proxy/connection.h>
#include <yt/yt/client/table_client/name_table.h>
#include <yt/yt/client/table_client/row_buffer.h>
#include <yt/yt/client/table_client/unversioned_row.h>

namespace NTravel {
namespace NYtRpc {

void Init() {
    NYT::NNet::TAddressResolver::Get()->Configure(NYT::New<NYT::NNet::TAddressResolverConfig>());// Move to main!
}

void Shutdown() {
    NYT::Shutdown();
}

TClientCreator::TClientCreator(const TString& user, const TString& tokenPath)
    : User(user)
    , Token(ReadSecret(tokenPath))
{
}

NYT::NApi::IClientPtr TClientCreator::CreateClient(const TString& clusterName) const {
    const auto connectionConfig = NYT::New<NYT::NApi::NRpcProxy::TConnectionConfig>();
    connectionConfig->ClusterUrl = clusterName;

    const auto connection = NYT::NApi::NRpcProxy::CreateConnection(connectionConfig);
    NYT::NApi::TClientOptions clientOptions;
    // don't change default username if no username in config
    if (!User.empty()) {
        clientOptions.User = User;
    }
    if (!Token.empty()) {
        clientOptions.Token = Token;
    }
    return connection->CreateClient(clientOptions);
}

}// NYtRpc

}// NTravel
