package yavconf

import (
	"a.yandex-team.ru/library/go/yandex/yav"
	"context"
	"errors"
	"fmt"
	"github.com/heetch/confita"
)

type Backend struct {
	client    yav.Client
	secretIDs []string
}

func (b *Backend) Name() string {
	return "yav"
}

// Get is not implemented.
func (b *Backend) Get(ctx context.Context, key string) ([]byte, error) {
	return nil, errors.New("not implemented")
}

func (b *Backend) LoadStruct(ctx context.Context, cfg *confita.StructConfig) error {
	for _, secretID := range b.secretIDs {
		secret, err := b.client.GetVersion(ctx, secretID)
		if err != nil {
			return fmt.Errorf("unable to load secrets for id %s: %w", secretID, err)
		}
		if secret.Response.Status != "ok" {
			return fmt.Errorf("unable to load secrets for id %s: %w", secretID, fmt.Errorf("unexpected yav response %v", secret.Response))
		}
		var resolved = map[string]string{}
		for _, v := range secret.Version.Values {
			resolved[v.Key] = v.Value
		}
		for _, f := range cfg.Fields {
			if f.Backend != "" && f.Backend != "yav" {
				continue
			}
			val, exists := resolved[f.Key]
			if exists {
				if f.Value.String() == "" || f.Default.String() == f.Value.String() {
					f.Value.SetString(val)
				}
			}
		}
	}
	return nil
}

func NewBackend(client yav.Client, secretIDs ...string) *Backend {
	return &Backend{
		client:    client,
		secretIDs: secretIDs,
	}
}
