package ytqueue

import (
	"a.yandex-team.ru/library/go/core/log"
	"time"
)

type deduplicationCache struct {
	duration time.Duration
	new      map[string]bool
	old      map[string]bool
	nextSwap time.Time
	logger   log.Logger
}

func newDeduplicationCache(duration time.Duration, logger log.Logger) deduplicationCache {
	return deduplicationCache{
		duration: duration,
		new:      make(map[string]bool),
		nextSwap: time.Now().Add(duration),
		logger:   logger,
	}
}

func (d *deduplicationCache) isKnown(key string) bool {
	if _, found := d.new[key]; found {
		return true
	}
	if _, found := d.old[key]; found {
		return true
	}
	d.new[key] = true
	now := time.Now()
	if d.nextSwap.Before(now) {
		d.logger.Debugf("Rollover in dedup cache: oldgen contains %d records, new gen contains %d records",
			len(d.old), len(d.new))
		d.old = d.new
		d.new = make(map[string]bool)
		d.nextSwap = now.Add(d.duration)
	}
	return false
}
