package ytstorage

import (
	"github.com/mitchellh/go-homedir"
	"io/ioutil"
	"strings"
)

type Config struct {
	Token string `config:"yt-token,required"`
	Proxy string `config:"yt-proxy,required"`
}

var DefaultConfig = Config{
	Proxy: "hahn",
}

func (c *Config) LoadTokenFromFile() error {
	home, err := homedir.Dir()
	if err != nil {
		return err
	}
	content, err := ioutil.ReadFile(home + "/.yt/token")
	if err != nil {
		return err
	}
	c.Token = strings.TrimSpace(string(content))
	return nil
}
