package ru.yandex.travel.hotels.busbroker;

import java.time.LocalDate;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.hotels.busbroker.model.DateRange;
import ru.yandex.travel.hotels.busbroker.model.OfferInvalidationRsp;
import ru.yandex.travel.hotels.busbroker.model.OfferInvalidatonReq;
import ru.yandex.travel.hotels.proto.EOfferInvalidationSource;
import ru.yandex.travel.hotels.proto.EPartnerId;

public interface BusBrokerClient {
    public CompletableFuture<OfferInvalidationRsp> invalidateOffersByTargetInterval(EPartnerId partnerId,
                                                                                    String originalId,
                                                                                    LocalDate fromInclusive,
                                                                                    LocalDate toInclusive,
                                                                                    EOfferInvalidationSource offerInvalidationSource);

    public CompletableFuture<OfferInvalidationRsp> invalidateOffersByCheckInOut(EPartnerId partnerId,
                                                                                String originalId,
                                                                                LocalDate checkIn,
                                                                                LocalDate checkOut,
                                                                                EOfferInvalidationSource offerInvalidationSource);

    CompletableFuture<OfferInvalidationRsp> invalidateOffersByCheckInOut(EPartnerId partnerId,
                                                                         String originalId,
                                                                         List<DateRange> dateRanges,
                                                                         EOfferInvalidationSource offerInvalidationSource);

    public CompletableFuture<OfferInvalidationRsp> invalidateOffersRaw(OfferInvalidatonReq offerInvalidatonReq);
}

