package ru.yandex.travel.hotels.busbroker;

import java.time.LocalDate;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.busbroker.model.DateRange;
import ru.yandex.travel.hotels.busbroker.model.OfferInvalidationRsp;
import ru.yandex.travel.hotels.busbroker.model.OfferInvalidatonReq;
import ru.yandex.travel.hotels.proto.EOfferInvalidationSource;
import ru.yandex.travel.hotels.proto.EPartnerId;

@Slf4j
public class NoopBusBrokerClient implements BusBrokerClient {

    @Override
    public CompletableFuture<OfferInvalidationRsp> invalidateOffersByTargetInterval(EPartnerId partnerId,
                                                                                    String originalId,
                                                                                    LocalDate fromInclusive,
                                                                                    LocalDate toInclusive,
                                                                                    EOfferInvalidationSource offerInvalidationSource) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<OfferInvalidationRsp> invalidateOffersByCheckInOut(EPartnerId partnerId, String originalId, LocalDate checkIn, LocalDate checkOut, EOfferInvalidationSource offerInvalidationSource) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<OfferInvalidationRsp> invalidateOffersByCheckInOut(EPartnerId partnerId, String originalId, List<DateRange> dateRanges, EOfferInvalidationSource offerInvalidationSource) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<OfferInvalidationRsp> invalidateOffersRaw(OfferInvalidatonReq offerInvalidatonReq) {
        return CompletableFuture.completedFuture(null);
    }
}
