package ru.yandex.travel.hotels.busbroker.model;

import java.time.Instant;
import java.time.LocalDate;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.travel.commons.proto.ECurrency;
import ru.yandex.travel.hotels.common.Permalink;
import ru.yandex.travel.hotels.proto.EOfferInvalidationSource;
import ru.yandex.travel.hotels.proto.THotelId;

@Data
@NoArgsConstructor
public class OfferInvalidatonReq {
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class CheckInCheckOutFilter {
        LocalDate checkInDate;
        LocalDate checkOutDate;
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TargetIntervalFilter {
        LocalDate dateFromInclusive;
        LocalDate dateToInclusive;
    }

    @Getter
    public static class Filter {
        CheckInCheckOutFilter checkInCheckOutFilter;
        TargetIntervalFilter targetIntervalFilter;

        public Filter(CheckInCheckOutFilter checkInCheckOutFilter) {
            this.checkInCheckOutFilter = checkInCheckOutFilter;
        }

        public Filter(TargetIntervalFilter targetIntervalFilter) {
            this.targetIntervalFilter = targetIntervalFilter;
        }
    }

    THotelId hotelId;
    Permalink permalink;

    ECurrency currency;
    Instant timestamp;
    List<Filter> filters;
    EOfferInvalidationSource offerInvalidationSource;
}
